package gov.va.genisis2.converter;

import static org.junit.Assert.*;

import org.junit.Before;
import org.junit.Test;

import gov.va.genisis2.AbstractMockMvcTests;
import gov.va.genisis2.common.enums.RefreshStatusEnum;
import gov.va.genisis2.model.RefreshHistory;
import gov.va.genisis2.util.DateUtil;
import gov.va.genisis2.util.Helper;

/**
 * 
 * @author Getaneh Kassahun
 * 
 */

public class RefreshHistoryConverterTest extends AbstractMockMvcTests {

	/** The userRefreshHistoryConverter. */
	private RefreshHistoryConverter userRefreshHistoryConverter;

	/** The userRefreshHistory. */
	private RefreshHistory userRefreshHistory;

	/** Run before all test methods. */
	@Before
	public void setUp() {
		userRefreshHistoryConverter = new RefreshHistoryConverter();
	}

	/**
	 * To testPopulateUserRefreshHistory_Username.
	 * 
	 */
	@Test
	public void testPopulateUserRefreshHistory_Username() {
		userRefreshHistory = userRefreshHistoryConverter.populateUserRefreshHistory("NightlyJob", "Users");
		assertEquals("NightlyJob", userRefreshHistory.getScheduledBy());

	}

	/**
	 * To testPopulateUserRefreshHistory_UserRefreshHistory.
	 * 
	 */
	@Test
	public void testPopulateUserRefreshHistory_UserRefreshHistory() {
		userRefreshHistory = userRefreshHistoryConverter.populateUserRefreshHistory("NightlyJob", "Users");
		assertEquals("NightlyJob", userRefreshHistoryConverter.populateUserRefreshHistory(userRefreshHistory).getScheduledBy());

		userRefreshHistory = userRefreshHistoryConverter.populateUserRefreshHistory(userRefreshHistory, "errorMessage");
		assertEquals("errorMessage", userRefreshHistory.getErrorMessage());
	}
	
	@Test
	public void populateStudyApprovalRefreshHistory() {

		assertEquals("NightlyJob", userRefreshHistoryConverter.populateStudyApprovalRefreshHistory("NightlyJob").getScheduledBy());
		assertEquals("StudyApproval", userRefreshHistoryConverter.populateStudyApprovalRefreshHistory("NightlyJob").getJobType());
		assertNotSame("Users", userRefreshHistoryConverter.populateStudyApprovalRefreshHistory("NightlyJob").getJobType());
	}
	
	@Test
	public void populateStudyApprovalRefreshHistory_Completed() {

		assertEquals("Completed", userRefreshHistoryConverter.populateStudyApprovalRefreshHistory(Helper.getUserRefreshHistory()).getStatus());
		assertEquals("NightlyJob", userRefreshHistoryConverter.populateStudyApprovalRefreshHistory(Helper.getUserRefreshHistory()).getScheduledBy());
		assertNotSame("Faild", userRefreshHistoryConverter.populateStudyApprovalRefreshHistory(Helper.getUserRefreshHistory()).getStatus());
	}
	
	@Test
	public void populateStudyApprovalRefreshHistory_Failed() {

		assertEquals("Failed", userRefreshHistoryConverter.populateStudyApprovalRefreshHistory(Helper.getUserRefreshHistory(), "Failed").getStatus());
		assertEquals("NightlyJob", userRefreshHistoryConverter.populateStudyApprovalRefreshHistory(Helper.getUserRefreshHistory(), "Failed").getScheduledBy());
		assertNotSame("Completed", userRefreshHistoryConverter.populateStudyApprovalRefreshHistory(Helper.getUserRefreshHistory(), "Failed").getStatus());
	}

}
